# Dołaczanie czujnikow temperatury do Enviro Grow
# Na podstawie projektu 
#  "Pomiar parametrów otoczenia w tym prędkość i kierunek wiatru, opady deszczu i wilgotność powietrza"
#  autorzy: Miłosz Brym, Magdalena Wielgolewska, Wojciech Danielewicz, Mieszko Mazurkiewicz i Martyna Stankiewicz
# ---------------------------------------------------------

# Enviro - wireless environmental monitoring and logging
#
# On first run Enviro will go into provisioning mode where it appears
# as a wireless access point called "Enviro <board type> Setup". Connect
# to the access point with your phone, tablet or laptop and follow the
# on screen instructions.
#
# The provisioning process will generate a `config.py` file which 
# contains settings like your wifi username/password, how often you
# want to log data, and where to upload your data once it is collected.
#
# You can use enviro out of the box with the options that we supply
# or alternatively you can create your own firmware that behaves how
# you want it to - please share your setups with us! :-)
#
# Need help? check out https://pimoroni.com/enviro-guide
#
# Happy data hoarding folks,
#
#   - the Pimoroni pirate crew
# uncomment the below two lines to change the amount of logging enviro will do
# from phew import logging
# logging.disable_logging_types(logging.LOG_DEBUG)
# Issue #117 where neeed to sleep on startup otherwis emight not boot

from time import sleep
sleep(0.5)
# import enviro firmware, this will trigger provisioning if needed
import enviro
import os
import picographics
from picographics import PicoGraphics, DISPLAY_INKY_PACK
import machine, onewire, ds18x20, time
from ADS1115 import *

ds_pin = machine.Pin(16)
ds_sensor = ds18x20.DS18X20(onewire.OneWire(ds_pin))
roms = ds_sensor.scan()

ADS1115_ADDRESS = 0x48
i2c = machine.I2C(0, scl=machine.Pin(5), sda=machine.Pin(4), freq=400000)
adc = ADS1115(ADS1115_ADDRESS, i2c=i2c)
adc.setVoltageRange_mV(ADS1115_RANGE_4096)  #6144
adc.setCompareChannels(ADS1115_COMP_0_GND)
adc.setMeasureMode(ADS1115_SINGLE)

display = PicoGraphics(display=DISPLAY_INKY_PACK)
glebaadc = machine.ADC(28)
WIDTH, HEIGHT = display.get_bounds()
display.set_update_speed(2)
display.set_font("bitmap8")
display.set_pen(100)
display.clear()
display.update()

def temperature_dirt(roms):
    temperatura = []
    ds_sensor.convert_temp()
    time.sleep_ms(750)
    for rom in roms:
        tnum = ds_sensor.read_temp(rom)
        temperatura.append(round(tnum,2))
    srednia = sum(temperatura)/len(temperatura)
    #print("Temperature [0,1]:", temperatura)
    return temperatura

def readChannel(channel):
        adc.setCompareChannels(channel)
        adc.startSingleMeasurement()
        while adc.isBusy():
            pass
        voltage = adc.getResult_V()
        return voltage

def clear():
    display.set_pen(100)
    display.clear()
    display.update()
    #296x128

def displaying():
  sensor = ds_sensor.scan()
  display.set_pen(0)
  temperature = reading.get("temperature")
  humidity = reading.get("humidity")
  moisture_a = reading.get("moisture_a")
  luminance = reading.get("luminance")
  pressure = reading.get("pressure")
  temperature_d = temperature_dirt(sensor)
  moisture_adcV = readChannel(ADS1115_COMP_0_GND)
  print(moisture_adcV)
  sleep(0.5)
  moisture_adcV = readChannel(ADS1115_COMP_0_GND)
  print(moisture_adcV)
  sleep(0.5)
  moisture_adcV = readChannel(ADS1115_COMP_0_GND)
  print(moisture_adcV)
  sleep(0.5)
  moisture_adcV = readChannel(ADS1115_COMP_0_GND)
  print(moisture_adcV)
  sleep(0.5)
  moisture_adcV = readChannel(ADS1115_COMP_0_GND)
  print(moisture_adcV)
  
  #moisture_adc = (moisture_adcV-0.07)*100/2.9
  #moisture_adc = 2.8432*moisture_adcV**3 - 9.1993*moisture_adcV**2 + 20.2553*moisture_adcV - 4.1882
  #moisture_adc = (moisture_adc +2.74)*100/46.59
  moisture_adc = moisture_adcV*15.2393 - 4.7240
  #moisture_adc = 1.3843*(moisture_adcV**2) + 11.7824*moisture_adcV - 0.8700 # 3.1500
  print(moisture_adc)
  if moisture_adc<0:
      moisture_adc=0
  moisture_adc = round(moisture_adc, 2)
  print(moisture_adc)
  
  display.text("Temp: " + "{:.2f}".format(temperature) + "°C", 5, 5, scale=2)  
  display.text("Wilg: "+ "{:.2f}".format(humidity) + "%", 5, 30, scale=2)
  display.text("[Gleba]  Próg pompki: 50% ", 5, 55, scale=2)
  display.text("Wilg: " + "{:.2f}".format(moisture_a) + "%", 5, 80, scale=2)
  display.text("VWC: "+ "{:.2f}".format(moisture_adc) + "%", 5, 105, scale=2)
  
  display.text("Osw: "+ "{:.2f}".format(luminance) + "lx", 150, 5, scale=2)
  display.text("Cis: "+ "{:.2f}".format(pressure) + "hPa", 150, 30, scale=2)
  display.text("Temp1: " + "{:.2f}".format(temperature_d[0]) + "°C", 150, 80, scale=2)
  display.text("Temp2: " + "{:.2f}".format(temperature_d[1]) + "°C", 150, 105, scale=2)
  display.update()
    
try:
  # initialise enviro
  enviro.startup()
# if the clock isn't set...
  if not enviro.is_clock_set():
    enviro.logging.info("> clock not set, synchronise from ntp server")
    if not enviro.sync_clock_from_ntp():
      # failed to talk to ntp server go back to sleep for another cycle
      enviro.halt("! failed to synchronise clock")  
  # check disk space...
  if enviro.low_disk_space():
    # less than 10% of diskspace left, this probably means cached results
    # are not getting uploaded so warn the user and halt with an error
    
    # Issue #126 to try and upload if disk space is low
    # is an upload destination set?
    if enviro.config.destination:
      enviro.logging.error("! low disk space. Attempting to upload file(s)")
      # if we have enough cached uploads...
      enviro.logging.info(f"> {enviro.cached_upload_count()} cache file(s) need uploading")
      if not enviro.upload_readings():
        enviro.halt("! reading upload failed")
    else:
      # no destination so go to sleep
      enviro.halt("! low disk space")
  # TODO this seems to be useful to keep around?
  filesystem_stats = os.statvfs(".")
  enviro.logging.debug(f"> {filesystem_stats[3]} blocks free out of {filesystem_stats[2]}")
  # TODO should the board auto take a reading when the timer has been set, or wait for the time?
  # take a reading from the onboard sensors
  enviro.logging.debug(f"> taking new reading")
  reading = enviro.get_sensor_readings()
  displaying()
  # here you can customise the sensor readings by adding extra information
  # or removing readings that you don't want, for example:
  # 
  #   del readings["temperature"]        # remove the temperature reading
  #
  #   readings["custom"] = my_reading()  # add my custom reading value
  # is an upload destination set?

  if enviro.config.destination:
    # if so cache this reading for upload later
    enviro.logging.debug(f"> caching reading for upload")
    enviro.cache_upload(reading)
    # if we have enough cached uploads...
    if enviro.is_upload_needed():
      enviro.logging.info(f"> {enviro.cached_upload_count()} cache file(s) need uploading")
      if not enviro.upload_readings():
        enviro.halt("! reading upload failed")
    else:
      enviro.logging.info(f"> {enviro.cached_upload_count()} cache file(s) not being uploaded. Waiting until there are {enviro.config.upload_frequency} file(s)")
  else:
    # otherwise save reading to local csv file (look in "/readings")
    enviro.logging.debug(f"> saving reading locally")
    enviro.save_reading(reading)
    
  # go to sleep until our next scheduled reading
  enviro.sleep()
# handle any unexpected exception that has occurred
except Exception as exc:
  enviro.exception(exc)


