"""
 Czujniki serii MQ i Fermion
 Pomiary gazów ze sterowaniem czasowym
 ---------------------------------------------------------
"""
import machine
from machine import ADC, Pin, UART, I2C
#from pimoroni_i2c import PimoroniI2C
from picographics import PicoGraphics, DISPLAY_INKY_PACK
import time
import utime
import random
import math
from time import sleep
from ADS1115 import *

# ---------------------------------------------------------
sleep_time = 1	# sleep time, seconds
ADC_count = 10	# 8sps 0,5s x 10 = 5s measurement averaging counter
heat_time = 60	#60
read_time = 90	#90
plot_flag = 1	
store_to_file_flag = 1

# ADC sampling indicator
pin_output = machine.Pin(0, machine.Pin.OUT)
pin_output.low()

# Enable1 MQ-7 and MQ-9  60/90s
pin_output1 = machine.Pin(1, machine.Pin.OUT)
pin_output1.low()	# Hot 

# Enable2 SEN-0564  60/90s
pin_output2 = machine.Pin(2, machine.Pin.OUT)
pin_output2.low()	# 0,5V masure

# Enable3 SEN-0440  aktyne poziomem LOW
pin_output3 = machine.Pin(3, machine.Pin.OUT)
pin_output3.high()	# OFF

# Board LED
LED_board = machine.Pin(25, machine.Pin.OUT)
LED_board.low()		# OFF


if store_to_file_flag ==1:
    #file_path = "gas_data.csv"
    file_path = "CO_gas_data.txt"
    with open(file_path, "w") as f:
        #f.write("CO Gas\n")
        f.write("SEN440 MQ-7 SEN564 MQ-9\n")

# ---------------------------------------------------------
# Inicjalizacja i sprawdzanie polaczen
# ADS1115 0x48[72] 3,4MHz
def check_connections():
    i2c1 = I2C(0, scl=Pin(5), sda=Pin(4), freq=400000) # GP4, GP5  100000  400000  1000000 3400000
    i2c_dev_list = i2c1.scan()
    if len(i2c_dev_list) == 0:
        print("No I2C devices found, terminating")
        #sys.exit(1)
    if plot_flag == 0:
        print(" ADS1115 0x48/0x49")
        print("Detected devices at I2C1-addresses:")
        print(["0x{:02X}".format(x) for x in i2c_dev_list])
        print("Decimal address: ",i2c_dev_list)
    
    # Sprawdzanie ADS1115  0x48[72]
    if not 72 in i2c_dev_list:
        print("Failed to contact ADS1115")
        ads_flag = False
    else:
        ads1115_flag = True
        if plot_flag == 0:
            print("ADS1115 OK")

    sen_flag = False
    return [sen_flag, ads1115_flag]

# ---------------------------------------------------------
# CZYTANIE DANYCH Z CZUJNIKA CO ZA POMOCA ADS1115
# funkcja odpowiedzialna za odczyt napiecia przez ADC
def readChannel(channel):
    adc.setCompareChannels(channel)
    #print("ADS start")
    pin_output.high()
    adc.startSingleMeasurement()
    while adc.isBusy():
        pass
        #print("ADS pass")
    pin_output.low()
    #print("ADS stop")
    voltage = adc.getResult_V()
    return voltage

# ---------------------------------------------------------
# Check I2C devices
[sen_flag, ads1115_flag] = check_connections()


# konfiguracja ADS1115
ADS1115_ADDRESS = 0x48
i2c = I2C(0)
adc = ADS1115(ADS1115_ADDRESS, i2c=i2c)
adc.setVoltageRange_mV(ADS1115_RANGE_2048)	# 0256 0512 1024 2048 4096 6144  +-mV
adc.setCompareChannels(ADS1115_COMP_0_GND)
adc.setConvRate(ADS1115_8_SPS) 				#8  860
adc.setMeasureMode(ADS1115_SINGLE)

# konfiguracja wyswietlacza
display = PicoGraphics(display=DISPLAY_INKY_PACK)
WIDTH, HEIGHT = display.get_bounds()
display.set_update_speed(2)
display.set_font("bitmap8")
display.set_pen(15) # White
#display.clear()
#display.update()


# Enable3 SEN-0440
pin_output3.low()	# ON

### Main Loop ###
while True:    
    #LED_board.high()

    # Heating 
    # Enable1 MQ-7 and MQ-9  60/90s
    pin_output1.high()	# 5V hHOT
    # Enable2 SEN-0564  60/90s
    pin_output2.high()	# 2,5V HOT
    # Enable3 SEN-0440
    pin_output3.low()	# EN\ ON
    sleep(heat_time)	# 60s
    
    # Measurement
    # Enable1 MQ-7 and MQ-9  60/90s
    pin_output1.low()	# 1,5V measure
    # Enable2 SEN-0564  60/90s
    pin_output2.low()	# 0,5V measure
    # Enable3 SEN-0440
    #pin_output3.low()	# EN\ ON
    sleep(read_time)	# 90s

    LED_board.high()
    sleep(2)	# 2S

    # Odczyt napiecia
    #ADC_count = 10	# 8sps 0,5s x 10 = 5s
    Vgas1 = 0
    Vgas2 = 0
    Vgas3 = 0
    Vgas4 = 0
    for i in range(0, ADC_count):
      Vgas1 += readChannel(ADS1115_COMP_0_GND)
      Vgas2 += readChannel(ADS1115_COMP_1_GND)
      Vgas3 += readChannel(ADS1115_COMP_2_GND)
      Vgas4 += readChannel(ADS1115_COMP_3_GND)
    Vgas1 /= ADC_count
    Vgas2 /= ADC_count
    Vgas3 /= ADC_count
    Vgas4 /= ADC_count

    # Disable3 SEN-0440
    pin_output3.high()	# OFF

"""
    # Automatyczna zmiana zakresu ADC?
    th1=2048/1000
    if ((Vgas1 > th1) or (Vgas2 > th1) or (Vgas3 > th1) or (Vgas4 > th1)): 
        #print("4096")
        adc.setVoltageRange_mV(ADS1115_RANGE_4096)	# 256 512 1024 2048 4096 6144  +-mV
    else:
        th1=1024/1000
        if ((Vgas1 > th1) or (Vgas2 > th1) or (Vgas3 > th1) or (Vgas4 > th1)): 
            #print(2048)
            adc.setVoltageRange_mV(ADS1115_RANGE_2048)	# 256 512 1024 2048 4096 6144  +-mV
        else:
            th1=512/1000
            if ((Vgas1 > th1) or (Vgas2 > th1) or (Vgas3 > th1) or (Vgas4 > th1)): 
                #print(1024)
                adc.setVoltageRange_mV(ADS1115_RANGE_1024)	# 256 512 1024 2048 4096 6144  +-mV
            else:
                th1=256/1000
                if ((Vgas1 > th1) or (Vgas2 > th1) or (Vgas3 > th1) or (Vgas4 > th1)): 
                    #print(512)
                    adc.setVoltageRange_mV(ADS1115_RANGE_512)	# 256 512 1024 2048 4096 6144  +-mV
""" 

    
    if plot_flag == 0:
        #print("Vgas1:  ", Vgas1, "Vgas2:  ", Vgas2, "Vgas3:  ", Vgas3, "Vgas4:  ", Vgas4)
        print("CO(SEN440): ", Vgas1, "CO(MQ7): ", Vgas2, "CO(SEN564): ", Vgas3, "CO(MQ9): ", Vgas4, " ", th1 )
        #print("s(SEN-0440): ", Vgas1, "Smoke(SEN-0570): ", Vgas2, "CO(SEN-0564): ", Vgas3, "Smoke(MQ-2): ", Vgas4 )
    else:
        print("CO(SEN440): ", Vgas1, "CO(MQ7): ", Vgas2, "CO(SEN564): ", Vgas3, "CO(MQ9): ", Vgas4, " ", th1 )

    # ZAKTUALIZOWANIE PLIKU DATA.TXT
    if store_to_file_flag == 1:	 # Save data to file
        if plot_flag == 0:
            print("Writing to the", file_path, "data.txt file")
        #data_line = "{:0.2f},{:0.2f},{:0.2f},{:0.2f}\n".format(temperature, pressure, humidity, gas)
        #data_line = "{:0.7f},{:0.7f},{:0.7f},{:0.7f},\n".format(Vgas1, Vgas2, Vgas3, Vgas4)
        data_line = "{:0.7f} {:0.7f} {:0.7f} {:0.7f} \n".format(Vgas1, Vgas2, Vgas3, Vgas4)
        with open(file_path, "a") as f:
            #f.write(str(file_flag) + ";" + hour + ";" + minute + ";" + second + ";" + day + ";" + month + ";" + year + ";" + str(meas_counter) + ";" + str(fan_counter)+ ";" + str(pm1p0) + ";" + str(pm2p5) + ";" + str(pm10p0))
            f.write(data_line)

    display.set_pen(15) # White
    display.clear()  
    #display.update()
    display.set_pen(0)  # Black
    display.text("CO", 0, 0, scale=2.5)
    display.text("SEN-0440 ", 0, 20, scale=2.5)
    display.text(str(Vgas1) + " mV", 100, 20, scale=2.0)
    display.text("MQ-7", 0, 40, scale=2.5)
    display.text(str(Vgas2) + " mV", 100, 40, scale=2.0)    
    display.text("SEN-0564", 0, 60, scale=2.5)
    display.text(str(Vgas3) + " mV", 100, 60, scale=2.0)    
    display.text("MQ-9", 0, 80, scale=2.5)
    display.text(str(Vgas4) + " mV", 100, 80, scale=2.0)
    #time.sleep(1)
    display.update()


    #if plot_flag == 0:
        #print("Sleep time")
    LED_board.low()
    sleep(sleep_time)

