# Detekcja pożaru z czujnikami płomieni i ruchu
# Na podstawie projektu 
#  "Autonomiczny układ wykrywania pożaru" 
#  autorzy: Amelia Malaszewska, Mikołaj Piotrowski, Mikołaj Bednarczyk i Jakub Kander
# ---------------------------------------------------------
import time
#from breakout_bme68x import BreakoutBME68X, STATUS_HEATER_STABLE, STATUS_GAS_VALID
from pimoroni_i2c import PimoroniI2C
from picographics import PicoGraphics, DISPLAY_INKY_PACK
from machine import Pin, I2C, Timer, UART
from ADS1115 import *
from breakout_bme68x import BreakoutBME68X, STATUS_HEATER_STABLE, FILTER_COEFF_127, STANDBY_TIME_500_MS, OVERSAMPLING_16X, OVERSAMPLING_2X, OVERSAMPLING_1X, STATUS_HEATER_STABLE, STATUS_GAS_VALID

import machine
import micropython
micropython.alloc_emergency_exception_buf(1000)

# 0 1 UART(TX, RX)
# 2 Buzzer
# 3 Pir
# 4 5 I2C(SDA, SCL): BME688 ADS1115 INA219
# 6 mq control
# 7 ADS1115 PWR switch
# 12 13 14 display buttons(A, B, C)
# 25 LED

buzzer = Pin(2, Pin.OUT, value=1)
pir_p = Pin(3, Pin.IN)
pin6 = Pin(6, Pin.OUT, value=0)
ads_ctrl = Pin(7, Pin.OUT, value=0)
button_a = Pin(12, Pin.IN, Pin.PULL_UP)
button_b = Pin(13, Pin.IN, Pin.PULL_UP)
button_c = Pin(14, Pin.IN, Pin.PULL_UP)
led = Pin(25, Pin.OUT)


#--------------------------------------------------------#
#poczatek ina#
# Config Register (R/W)
_REG_CONFIG                 = 0x00
# SHUNT VOLTAGE REGISTER (R)
_REG_SHUNTVOLTAGE           = 0x01

# BUS VOLTAGE REGISTER (R)
_REG_BUSVOLTAGE             = 0x02

# POWER REGISTER (R)
_REG_POWER                  = 0x03

# CURRENT REGISTER (R)
_REG_CURRENT                = 0x04

# CALIBRATION REGISTER (R/W)
_REG_CALIBRATION            = 0x05

class BusVoltageRange:
    """Constants for ``bus_voltage_range``"""
    RANGE_16V               = 0x00      # set bus voltage range to 16V
    RANGE_32V               = 0x01      # set bus voltage range to 32V (default)

class Gain:
    """Constants for ``gain``"""
    DIV_1_40MV              = 0x00      # shunt prog. gain set to  1, 40 mV range
    DIV_2_80MV              = 0x01      # shunt prog. gain set to /2, 80 mV range
    DIV_4_160MV             = 0x02      # shunt prog. gain set to /4, 160 mV range
    DIV_8_320MV             = 0x03      # shunt prog. gain set to /8, 320 mV range

class ADCResolution:
    """Constants for ``bus_adc_resolution`` or ``shunt_adc_resolution``"""
    ADCRES_9BIT_1S          = 0x00      #  9bit,   1 sample,     84us
    ADCRES_10BIT_1S         = 0x01      # 10bit,   1 sample,    148us
    ADCRES_11BIT_1S         = 0x02      # 11 bit,  1 sample,    276us
    ADCRES_12BIT_1S         = 0x03      # 12 bit,  1 sample,    532us
    ADCRES_12BIT_2S         = 0x09      # 12 bit,  2 samples,  1.06ms
    ADCRES_12BIT_4S         = 0x0A      # 12 bit,  4 samples,  2.13ms
    ADCRES_12BIT_8S         = 0x0B      # 12bit,   8 samples,  4.26ms
    ADCRES_12BIT_16S        = 0x0C      # 12bit,  16 samples,  8.51ms
    ADCRES_12BIT_32S        = 0x0D      # 12bit,  32 samples, 17.02ms
    ADCRES_12BIT_64S        = 0x0E      # 12bit,  64 samples, 34.05ms
    ADCRES_12BIT_128S       = 0x0F      # 12bit, 128 samples, 68.10ms

class Mode:
    """Constants for ``mode``"""
    POWERDOW                = 0x00      # power down
    SVOLT_TRIGGERED         = 0x01      # shunt voltage triggered
    BVOLT_TRIGGERED         = 0x02      # bus voltage triggered
    SANDBVOLT_TRIGGERED     = 0x03      # shunt and bus voltage triggered
    ADCOFF                  = 0x04      # ADC off
    SVOLT_CONTINUOUS        = 0x05      # shunt voltage continuous
    BVOLT_CONTINUOUS        = 0x06      # bus voltage continuous
    SANDBVOLT_CONTINUOUS    = 0x07      # shunt and bus voltage continuous
 
class INA219:
    def __init__(self, i2c_bus=0, addr=0x45):
        self.i2c = I2C(i2c_bus);
        self.addr = addr

        # Set chip to known config values to start
        self._cal_value = 0
        self._current_lsb = 0
        self._power_lsb = 0
        self.set_calibration_32V_2A()
        
    def read(self,address):
        data = self.i2c.readfrom_mem(self.addr, address, 2)
        return ((data[0] * 256 ) + data[1])

    def write(self,address,data):
        temp = [0,0]
        temp[1] = data & 0xFF
        temp[0] =(data & 0xFF00) >> 8
        self.i2c.writeto_mem(self.addr,address,bytes(temp))

    def set_calibration_32V_2A(self):
        self._current_lsb = 1 


        self._cal_value = 4096

        self._power_lsb = .002 

        self.write(_REG_CALIBRATION,self._cal_value)

        self.bus_voltage_range = BusVoltageRange.RANGE_32V
        self.gain = Gain.DIV_8_320MV
        self.bus_adc_resolution = ADCResolution.ADCRES_12BIT_32S
        self.shunt_adc_resolution = ADCResolution.ADCRES_12BIT_32S
        self.mode = Mode.SANDBVOLT_CONTINUOUS
        self.config = self.bus_voltage_range << 13 | \
                      self.gain << 11 | \
                      self.bus_adc_resolution << 7 | \
                      self.shunt_adc_resolution << 3 | \
                      self.mode
        self.write(_REG_CONFIG,self.config)
        
    def getShuntVoltage_mV(self):
        value = self.read(_REG_SHUNTVOLTAGE)
        if value > 32767:
            value -= 65535
        return value * 0.01
        
    def getBusVoltage_V(self):  
        self.read(_REG_BUSVOLTAGE)
        return (self.read(_REG_BUSVOLTAGE) >> 3) * 0.004
        
    def getCurrent_mA(self):
        value = self.read(_REG_CURRENT)
        if value > 32767:
            value -= 65535
        return value * self._current_lsb
    
    def get_power_mW(self):
        raw = self.read(_REG_POWER)
        return raw * self._power_lsb * 1000  # W->mW
    
#koniec ina#

# ---------------------------------------------------------
# I2C initialisation and check
# ADS1115 0x48[72] 3,4MHz
def check_connections():
    i2c1 = I2C(0, scl=Pin(5), sda=Pin(4), freq=100000) # GP4, GP5  100000  400000  1000000 3400000
    i2c_dev_list = i2c1.scan()
    if len(i2c_dev_list) == 0:
        print("No I2C devices found, terminating")
        #sys.exit(1)
    else:
        #print(" ADS1115 0x48/0x49")
        print("I2C0 (SCL-PIN5 SDA-PIN4): Detected devices:")
        print(["0x{:02X}".format(x) for x in i2c_dev_list])
        print("I2C0 Decimal address: ",i2c_dev_list)
    
    # ADS1115 #1 0x48[72]
    if not 72 in i2c_dev_list:
        print("Failed to contact ADS1115 #1 0x48")
        ads_flag1 = False
    return

#========
# Konfiguracja I2C
i2c=I2C(0, sda=Pin(4), scl=Pin(5), freq=100000)
check_connections()

# Konfiguracja BME688
bme = BreakoutBME68X(i2c, 0x77)
bme.configure(FILTER_COEFF_127, STANDBY_TIME_500_MS, OVERSAMPLING_16X, OVERSAMPLING_2X, OVERSAMPLING_1X)

# Konfiguracja INA219
ina219 = INA219(addr=0x45)

#$ Konfiguracja UART
uart = UART(0, baudrate = 115200, tx = Pin(0), rx = Pin(1), timeout=25000, timeout_char=30)

# Konfiguracja ADS1115 #1
ADS1115_ADDRESS = 0x48
i2c = I2C(0, scl=Pin(5), sda=Pin(4), freq=100000) # GP4, GP5  100000  400000  1000000 3400000
adc = ADS1115(ADS1115_ADDRESS, i2c=i2c)
adc.setVoltageRange_mV(ADS1115_RANGE_4096)	# 0256 0512 1024 2048 4096 6144  +-mV
adc.setCompareChannels(ADS1115_COMP_0_GND)
adc.setConvRate(ADS1115_8_SPS) 				#8 16 32 64 128 250 475 860
adc.setMeasureMode(ADS1115_SINGLE)
flame_adc_channel = 0

# Konfiguracja Pico Inky
display = PicoGraphics(display=DISPLAY_INKY_PACK)
display.set_update_speed(2)
display.set_font("bitmap8")

# ====================================================
INITIAL_BASELINE_DURATION_S = 2 * 60  # 2 minuty

LEARNING_RATE_UP = 0.01

MEASUREMENT_INTERVAL_S = 10

LEARNING_RATE_DOWN = LEARNING_RATE_UP / 10
display.set_pen(15)
display.clear()
display.set_pen(0)
display.text(f"START", 10, 10, 240, 2)	#Start
display.update()

#print("Wait please")

#first reading may be unstable
temperature, pressure, humidity, gas_res, status1, _, _ = bme.read() # default:single measurement profile, 300degC, 100ms
heater1 = "Stable" if status1 & STATUS_HEATER_STABLE else "Unstable"
gas_valid1 = (status1 & STATUS_GAS_VALID) != 0
print("{:0.2f}°C, {:0.2f}Pa, {:0.2f}%, {:0.2f} Ohm, Heater Status: {}, Gas valid: {}".format(temperature, pressure, humidity, gas_res, heater1, gas_valid1))
temperature, pressure, humidity, gas_res, status2, _, _ = bme.read() # default:single measurement profile, 300degC, 100ms
heater2 = "Stable" if status2 & STATUS_HEATER_STABLE else "Unstable"
gas_valid2 = (status2 & STATUS_GAS_VALID) != 0
print("{:0.2f}°C, {:0.2f}Pa, {:0.2f}%, {:0.2f} Ohm, Heater Status: {}, Gas valid: {}".format(temperature, pressure, humidity, gas_res, heater2, gas_valid2))

#--------------------------------------------------------#
# Gas baseline
baseline_readings = []
start_time = time.ticks_ms()
cnt=0
print("Gas baseline collection: 2min")
while time.ticks_diff(time.ticks_ms(), start_time) < INITIAL_BASELINE_DURATION_S * 1000:
    try:
        led.value(1)
        temperature, pressure, humidity, gas_res, status, _, _ = bme.read()
        temperature, pressure, humidity, gas_res, status, _, _ = bme.read()
        heater = "Stable" if status & STATUS_HEATER_STABLE else "Unstable"
        gas_valid = (status & STATUS_GAS_VALID) != 0
        cnt = cnt +1
        #    temperature, pressure, humidity, gas, heater))
        if status & STATUS_HEATER_STABLE:
            print("{:0.2f} {:0.2f}°C  {:0.2f}Pa  {:0.2f}%  {:0.2f} Ohms  Heater: {}  Gas_valid: {}".format(
            cnt, temperature, pressure, humidity, gas_res, heater, gas_valid))        
        else:
            print("Heater niestabilny")

        #temp, press, hum, gas_res, status, _, _ = bme.read()
        gas_valid = (status & STATUS_GAS_VALID) != 0
        if gas_res is not None and gas_valid:
            baseline_readings.append(gas_res)
            #print(f"{gas_res:.0f}")
        else:
            print("Odczyt gazu blad.")
        led.value(0)
        time.sleep(MEASUREMENT_INTERVAL_S)
    except Exception as e:
        print(f"Blad podczas odczytu inicjalizacyjnego: {e}")
        time.sleep(MEASUREMENT_INTERVAL_S) # Spróbuj ponownie po przerwie

readings_for_initial_calc = baseline_readings[-(60 // MEASUREMENT_INTERVAL_S):] # Ostatnie 5 minut
if not readings_for_initial_calc: # Jeśli nie ma odczytów (np. błąd ciągły)
     readings_for_initial_calc = baseline_readings # Użyj wszystkiego co jest

if readings_for_initial_calc:
    current_baseline = sum(readings_for_initial_calc) / len(readings_for_initial_calc)
    print(f"Gas Baseline: {current_baseline:.0f} Ohm")
else:
    current_baseline = 80000 # Przykładowa wartość awaryjna
    print("\nOSTRZ.")

display.set_pen(15)
display.clear()
display.set_pen(0)
display.text(f"Sensors reading", 10, 10, 240, 2)	#Pomiar
display.update()
#--------------------------------------------------------#

flame_alarm = 2000	#3000
bme_alarm = -20000	#-3000
uno = [0,0]
was_error = 0
bme_gas = 0
tone_fire = [(0.15, 0.05)] * 4 + [(0.15, 0.3)] * 2
tone_error = [(0.05, 0.05)] * 10
flame_val = None

def play_tone(tune):
    for on_t, off_t in tune:
        buzzer.value(0)
        led.value(1)
        time.sleep(on_t)
        buzzer.value(1)
        led.value(0)
        time.sleep(off_t)

def read_adc(channel, sensor_name=""):
    try:
        if hasattr(ADS1115, 'read'):
            val = ADS1115.read(channel)
            print("ADC: ",val)
            if val is None:
                print(f"Brak danych z {sensor_name} (kanal {channel})!")
                play_tone(tone_error)
            return val
    except Exception as e:
        print(f"Blad odczytu z {sensor_name} (kanal {channel}): {e}")
        play_tone(tone_error)
    return None

#--------------------------------------------------------#
# Flame sensor
# ---------------------------------------------------------
# CZYTANIE DANYCH Z CZUJNIKA IRED ZA POMOCA ADS1115
# funkcja odpowiedzialna za odczyt napiecia przez ADC
def readChannel(channel):
    adc.setCompareChannels(channel)
    #print("ADS start")
    #pin_output.high() # PIN6
    adc.startSingleMeasurement()
    while adc.isBusy():
        pass
        #print("ADS pass")
    #pin_output.low() # PIN6
    #print("ADS stop")
    voltage = adc.getResult_V()
    return voltage *1000

def call_ambulance():
  uart.write(b'but not for me\n')
  msg = uart.readline()
  print(msg)
  if msg != None:
    return msg
  else:
    return -1

def clear():
  display.set_pen(15)
  display.clear()
  display.set_pen(0)

def guzik_a(pin):
  print("aaaa")
  time.sleep_ms(80)

def guzik_b(pin):
  play_tone(tone_error)
  time.sleep_ms(80)

def guzik_c(pin):
  print("cccc")
  time.sleep_ms(80)

def pir(pin):
  print("PIR movement detection")
  check_fire_conditions(0)
  time.sleep_ms(100)

# Refresch display
def refresh_display(Timer):
  global uno, gas_res, current_baseline
  led.value(1)
  clear()
  if flame_val == None:
     sen1 = "NONE"
  elif flame_val < flame_alarm:
    sen1 = "NOT OK" 
  else: 
    sen1 = "OK"
  if uno[1] > bme_alarm:
    sen2 = "OK" 
  else: 
    sen2 = "NOT OK"
  bus_voltage = ina219.getBusVoltage_V()
  Per = bus_voltage/4.2*100
  if(Per<0):Per=0
  elif(Per>100):Per=100
  display.text(f"Flame: {flame_val}  {sen1}", 10, 30, 240, 2)
  display.text(f"Gas {bme_gas}   {sen2}", 10, 50, 240, 2)
  display.text(f"Gas delta {uno[1]} {sen2}", 10, 70, 240, 2)
  display.text(f"Temp {uno[0]} °C", 10, 90, 240, 2)
  display.text(f"BATT  {round(Per)}%", 10, 110, 240, 2)
  display.update()
  time.sleep_ms(10)
  led.value(0)

def check_fire_conditions(pin):
    global uno, bme_gas, current_baseline
    global flame_val
    ads_ctrl.value(1)
    # Flame read
    flame_val = readChannel(ADS1115_COMP_0_GND)
    # Gas read
    bme_gas_reading(0)
    # ACCU read
    bus_voltage = ina219.getBusVoltage_V()
    Per = bus_voltage/4.2*100
    if(Per<0):Per=0
    elif(Per>100):Per=100

    print("Gas: {:0.2f}  Baseline: {:0.2f}  Gas delta: {:0.2f}  FlameADC: {:0.2f}  FlameALARAM: {:0.2f}  Temp: {:0.2f}°C  BAT: {:0.2f}%".format(
        bme_gas, current_baseline, uno[1], flame_val, flame_alarm, uno[0], Per))        

    ads_ctrl.value(0)   
    refresh_display(0)

    if uno[1] is None or flame_val is None:
        print(uno[1], flame_val)
        print("Sensor nie odpowiada sprawdz polaczenia.")
        return 0

    if flame_val < flame_alarm or uno[1] < bme_alarm:
        refresh_display(0)
        print(" WYKRYTO POZAR! ROB ZDJECIE KAMERA")
        display.text(f"FIRE", 10, 10, 240, 2)
        display.update()
        time.sleep_ms(10)
        play_tone(tone_fire)
    
def bme_gas_reading(arg):
  global was_error, bme_gas, uno, current_baseline
  last_temp = uno[0]
  try:
        pin6.value(1)
        if was_error == 1:
            bme.read()
            bme.read()
            bme.read()
            was_error = 0
        temp, press, hum, gas_res, status, _, _ = bme.read()
        temp, press, hum, gas_res, status, _, _ = bme.read()
        gas_valid = (status & STATUS_GAS_VALID) != 0
        pin6.value(0)
        
        if gas_res is not None and gas_valid:
          delta = 0
          # Oblicz różnicę między odczytem a obecną linią bazową
          delta = gas_res - current_baseline
          #print(f"delta: {delta}, gas_res: {gas_res}, current_baseline: {current_baseline}")
          if(delta > 30000):
              return 0
          # Algorytm aktualizacji baseline
          if delta > 0:
              # Odczyt wyższy niż baseline -> powoli zwiększaj baseline
              current_baseline += delta * LEARNING_RATE_UP   # 0.01
          else:
              # Odczyt niższy lub równy baseline -> bardzo powoli obniżaj baseline
              # (delta jest ujemna lub zerowa, więc += działa poprawnie)
              current_baseline += delta * LEARNING_RATE_DOWN

          # Zabezpieczenie przed ujemną linią bazową (nie powinno się zdarzyć z rezystancją)
          if current_baseline < 1:
              current_baseline = 1
          # Obliczanie wskaźnika jakości powietrza jako % obecnego odczytu do baseline
          # Wartość ~100% = powietrze zgodne z linią bazową (czyste)
          # Wartość < 100% = potencjalne zanieczyszczenie (im niżej, tym gorzej)
          # Wartość > 100% = powietrze czystsze niż obecna linia bazowa
          relative_quality = (gas_res / current_baseline) * 100 if current_baseline > 0 else 100
          #print(f"Gas: {gas_res:.0f} Ohm | {delta} delta | Baseline: {current_baseline:.0f} Ohm | Jakosc wzgl.: {relative_quality:.1f}% | T: {temp:.1f}C | H: {hum:.1f}%")
          uno[0] = temp
          uno[1] = delta
          bme_gas = gas_res
        else:
          print(f"Odczyt gazu nieważny lub niedostępny. T: {temp:.1f}C | H: {hum:.1f}%")
  except Exception as e:
        print(f"Błąd w pętli głównej: {e}")
        was_error = 1

button_a.irq(trigger=Pin.IRQ_FALLING, handler=check_fire_conditions)
button_b.irq(trigger=Pin.IRQ_FALLING, handler=guzik_b)
button_c.irq(trigger=Pin.IRQ_FALLING, handler=refresh_display)
pir_p.irq(trigger=Pin.IRQ_FALLING, handler=pir)

check_fire_conditions(0)
#refresh_display(0)

#timer_r = Timer(-1)
#timer_r.init(mode=Timer.PERIODIC, period=10000, callback=bme_gas_reading)
timer_c = Timer(-1)
timer_c.init(mode=Timer.PERIODIC, period=10000, callback=check_fire_conditions)

li = 0
while(True):
  #li = li +1
  #print(li)
  time.sleep(2)
  
