#include <Wire.h>

void setup() {
  Serial.begin(9600);
  Wire.begin();
}

void loop() {
  float objTemp, ambTemp;
  readTemperature(objTemp, ambTemp);
  Serial.print("Tobj:");
  Serial.print(objTemp);
  Serial.print(",Tamb:");
  Serial.print(ambTemp);
  Serial.println();
  delay(1000);
}

void readTemperature(float &objTemp, float &ambTemp) {
  uint8_t data[7];
  Wire.beginTransmission(0x38);
  Wire.write(0xAA);
  Wire.endTransmission();
  delay(100);
  Wire.requestFrom(0x38, 7);
  if (Wire.available() == 7) {
    for (int i = 0; i < 7; i++) {
      data[i] = Wire.read();
    }
    // Obliczenie temperatury otoczenia (Bytes 6-4)
    uint32_t ambTempRaw = ((uint32_t)data[4] << 16) | ((uint32_t)data[5] << 8) | data[6];
    ambTemp = (ambTempRaw / 16777216.0) * 105.0 - 20.0;
    // Obliczenie temperatury obiektu (Bytes -1)
    uint32_t objTempRaw = ((uint32_t)data[1] << 16) | ((uint32_t)data[2] << 8) | data[3];
    objTemp = (objTempRaw / 16777216.0) * 130.0 - 20.0;
  }
}