#biblioteka stworzona przez: Łukasz Gójski
#wymaga dopracowania i dokończenia
#dane uzyskujemy metodą .get_fame w o C

#temperatura jest obecnie "dokładna" w zakresie 0 - 80 

import struct
import machine
import math

REF_TEMPERATURE = const(25)
ABSOLUTE_TEMP = const(273.15)
POW2TO6 = const(64)
POW2TO7 = const(128)
POW2TO8 = const(256)
POW2TO9 = const(512)
POW2TO10 =const(1024)
POW2TO11 =const(2048)
POW2TO18 =const(262144)
VDD_0 = const(3.3)

#i2c devive class for MLX class methods 
class I2CDevice:
    def __init__(self, i2c, device_address, probe=True):
        self.i2c = i2c
        self.device_address = device_address
        if probe:
            self._probe_for_device()

    def read_into(self, buf, *, start=0, end=None):
        if end is None:
            end = len(buf)
        self.i2c.readfrom_into(self.device_address, buf, start=start, end=end)

    def write(self, buf):
        self.i2c.writeto(self.device_address, buf)

    def write_then_read_into(self, out_buffer, in_buffer, *, out_start=0, out_end=None, in_start=0, in_end=None):
        if out_end is None:
            out_end = len(out_buffer)
        if in_end is None:
            in_end = len(in_buffer)
        self.i2c.writeto(self.device_address, memoryview(out_buffer)[out_start:out_end], False)
        self.i2c.readfrom_into(self.device_address, memoryview(in_buffer)[in_start:in_end])

    def _probe_for_device(self):
        try:
            self.i2c.writeto(self.device_address, b'')
        except OSError:
            try:
                result = bytearray(1)
                self.i2c.readfrom_into(self.device_address, result)
            except OSError:
                raise ValueError(f'No I2C device at address: 0x{self.device_address:x}')
            
#setting refresh rate in progress

class RefreshRate:
    REFRESH_0_5_HZ = 0b000
    REFRESH_1_HZ = 0b001
    REFRESH_2_HZ = 0b010
    REFRESH_4_HZ = 0b011
    REFRESH_8_HZ = 0b100
    REFRESH_16_HZ = 0b101
    REFRESH_32_HZ = 0b110
    REFRESH_64_HZ = 0b111


#main class 
class MLX90641:
    #eeprom memory constatnts array 
    ee_data = [0]*832
    #from parent library
    i2c_read_len = 128
    
    def __init__(self, i2c_bus: machine.I2C, address: int = 0x33) -> None:
        #from parent library
        self.inbuf = bytearray(2 * self.i2c_read_len)
        self.addrbuf = bytearray(2)
        self.i2c_device = I2CDevice(i2c_bus, address)
        self.received_frame = [0.0]*192
        self._i2c_read_words(0x2400, self.ee_data)

        #received_frame is sensor data from RAM

        #extract VDD
        self.K_Vdd = 0
        self.Vdd_25 = 0
        #extract PTAT
        self.Kv_PTAT = 0
        self.Kt_PTAT = 0
        self.v_ptat25 = 0
        self.alpha_PTAT = 0
        #extract px offsets
        self.px_offset_P0= [0.0]*192
        self.px_offset_P1= [0.0]*192
        #extract px alpha
        self.px_alpha = [0.0]*192
        #extract Kta
        self.px_Kta = [0.0]*192
        #extract Kv
        self.px_Kv = [0.0]*192
        #extract gain 
        self.gain_ee = 0
        #extract KsTa
        self.KsTA = 0
        #extract KsTo
        self.KsTo =  [0.0]*8
        #extract CT
        self.CT = [0]*8
        #extract alpha corr ranges
        self.Alpha_correction_ranges = [0.0]*8
        #extract emissivity
        self.Emissivity = 0 
        #extract aplha CP
        self.Alpha_CP = 0
        #extract offset alpha CP
        self.Aplha_CP_offset =0 
        #extract Kv Cp
        self.Kv_CP =0 
        #extract Kta CP
        self.Kta_CP = 0 
        #extract TGC
        self.TGC =0 
        #extract resolution
        self.resolution_ee = 0
        # get resolution corr
        self.resolution_corr = 0
        # get supply voltage
        self.Vdd=0 
        # get Ta
        self.Ta = 0
        # get read ram 
        #variables are as list due to usage of sme i2c read functions as for many eleements
        self.V_BE_data_0x0580=[0]
        self.data_0x0588=[0]
        self.data_0x058A=[0]
        self.V_PTAT_data_0x05A0=[0]
        self.data_0x05A8=[0]
        self.data_0x05AA=[0]
        self.data_Resolution_reg_0x800D=0
        # get gain 

        self.K_gain = 0 
        #gets all parameters from eeprom should be run at start of camera
        self._extract_parameters()

        #subpage_now
        self.subpage_status= 0 

        #fill all ee_data at init
        self._i2c_read_words(0x2400, self.ee_data)

    def get_frame(self, framebuf) -> None:
        #prepare current data from RAM before calculations
        self.get_read_RAM_others()

        self.get_resolution_restore()
        self.get_supply_voltage()
        self.get_current_Ta()
        self.get_K_gain()

        #get new image and process
        self._get_frame_data()
        self.process_image()
        #return image array
        framebuf[:]=self.received_frame
    
    #we get only image from updated subpage( 0 or 1)
    def _get_frame_data(self) -> None:

        data_ready = 0
        status_register = [0]
        
        while data_ready == 0:
            self._i2c_read_words(0x8000, status_register,end =1)
            data_ready = status_register[0] & 0x0008
            
        while (data_ready != 0):
      
            self._i2c_write_word(0x8000, 0x0030)
            self._i2c_read_words(0x8000, status_register,end =1)
            data_ready = status_register[0] & 0x0008
            self.subpage_status = status_register[0] & 0x0001

            # fill one image buffer with right frame from grid in RAM depending on subpage
            k=0 
            if self.subpage_status == 0:
                for i in range(0, 384,64):
                    temp_buffer = [0]*32
                    self._i2c_read_words(0x0400 + i,temp_buffer, end = 32)
                    for j in range(32):
                        if temp_buffer[j]> 32767:
                            temp_buffer[j]-=65536
                        self.received_frame[j + k*32]=temp_buffer[j]
                    k+=1

            elif self.subpage_status == 1:
                 for i in range(32, 384, 64):
                    temp_buffer = [0]*32
                    self._i2c_read_words(0x0400 + i,temp_buffer, end = 32)
                    for j in range(32):
                        if temp_buffer[j]> 32767:
                            temp_buffer[j]-=65536
                        self.received_frame[j+ k*32]=temp_buffer[j]
                    k+=1
    #converts received frame to temperaturew
    def process_image(self):
        #constannts are from datasheet

        Tr= self.Ta - 8
        TaK4 = (self.Ta+ABSOLUTE_TEMP)**4
        TrK4 = (Tr+ABSOLUTE_TEMP)**4
        Tar = TrK4 - ((TrK4-TaK4)/self.Emissivity)
        #can be changed work in progress
        # #subpages differ only by constants
        if self.subpage_status ==0 :

            #not used TGC = 0
            #CP_px_gain_P0 = self.data_0x0588[0]*self.K_gain
            #CP_px_offset = CP_px_gain_P0 - self.Aplha_CP_offset*(1+ self.Kta_CP*(self.Ta - REF_TEMPERATURE ))*(1+ self.Kv_CP*(self.Vdd - self.Vdd_0))

            for i in range(192): 
              
                self.received_frame[i]*= self.K_gain 
                self.received_frame[i]= self.received_frame[i] - self.px_offset_P0[i] * (
                    1 + self.px_Kta[i] * (self.Ta - REF_TEMPERATURE )
                ) * (
                    1 + self.px_Kv[i] * (self.Vdd - VDD_0)
                )

                # V_IR_comp = ((self.received_frame[i]- 0*CP_px_offset)/self.Emissivity)
                # px_Alpha_com = (self.px_alpha[i]- 0*self.Alpha_CP)*(1+self.KsTA*(self.Ta-25))
                # TGC should be 0

                V_IR_comp = self.received_frame[i]/self.Emissivity
                px_Alpha_com =self.px_alpha[i]*(1+self.KsTA*(self.Ta-REF_TEMPERATURE ))
               
                Sx = self.KsTo[2]*((px_Alpha_com**3)*(V_IR_comp+px_Alpha_com*Tar))**(1.0/4)
                
                self.received_frame[i] = ( V_IR_comp/(px_Alpha_com*(1-self.KsTo[2]*ABSOLUTE_TEMP)+Sx) + Tar) ** (1.0/4) - ABSOLUTE_TEMP
#work in progress
                # Toextra = math.sqrt(
                #    math.sqrt(V_IR_comp/(px_Alpha_com*(self.Alpha_correction_ranges[2]*(1+self.KsTo[2]*(To-self.CT[2])))) + Tar
                #    )
                # )-273.15
       
        elif self.subpage_status == 1:

            #not used
            #CP_px_gain_P1 = self.data_0x05A8[0]*self.K_gain
            #CP_px_offset1 = CP_px_gain_P1 - self.Aplha_CP_offset*(1+ self.Kta_CP*(self.Ta - REF_TEMPERATURE ))*(1+ self.Kv_CP*(self.Vdd - self.Vdd_0))

            for i in range(192): 
                self.received_frame[i]*= self.K_gain 
                self.received_frame[i]= self.received_frame[i] - self.px_offset_P1[i] * (
                    1 + self.px_Kta[i] * (self.Ta - REF_TEMPERATURE )
                ) * (
                    1 + self.px_Kv[i] * (self.Vdd - VDD_0)
                )

                # V_IR_comp = ((self.received_frame[i]- 0*CP_px_offset)/self.Emissivity)
                # px_Alpha_com = (self.px_alpha[i]- 0*self.Alpha_CP)*(1+self.KsTA*(self.Ta-25))
                # TGC should be 0

                V_IR_comp = self.received_frame[i]/self.Emissivity

                px_Alpha_com =self.px_alpha[i]*(1+self.KsTA*(self.Ta-REF_TEMPERATURE ))
               
                Sx = self.KsTo[2]*((px_Alpha_com**3)*(V_IR_comp+px_Alpha_com*Tar)) ** (1.0/4)
                
                self.received_frame[i] = ( V_IR_comp/(px_Alpha_com*(1-self.KsTo[2]*ABSOLUTE_TEMP)+Sx) + Tar) ** (1.0/4) -ABSOLUTE_TEMP
#work in progress
                # Toextra = math.sqrt(
                #    math.sqrt(V_IR_comp/(px_Alpha_com*(self.Alpha_correction_ranges[2]*(1+self.KsTo[2]*(To-self.CT[2])))) + Tar
                #    )
                # )-273.15
            
#from parent library
    def _i2c_write_word(self, write_address: int, data: int) -> None:
            cmd = bytearray(4)
            cmd[0] = write_address >> 8
            cmd[1] = write_address & 0x00FF
            cmd[2] = data >> 8
            cmd[3] = data & 0x00FF

            self.i2c_device.write(cmd)
#form parent library
    def _i2c_read_words(self, addr: int, buffer, *, end=None) -> None:
        remaining_words = end if end is not None else len(buffer)
        offset = 0

        while remaining_words > 0:
          
            self.addrbuf[0] = addr >> 8  # MSB
            self.addrbuf[1] = addr & 0xFF  # LSB

            read_words = min(remaining_words, self.i2c_read_len)
            self.i2c_device.write_then_read_into(
                self.addrbuf,
                self.inbuf,
                in_end=read_words * 2,
            )

            outwords = struct.unpack('>' + 'H' * read_words, self.inbuf[:read_words * 2])

            for i, word in enumerate(outwords):
                buffer[offset + i] = word

            offset += read_words
            addr += read_words
            remaining_words -= read_words
#extract data form eeprom memory, perform calculations, once per class creation
    def _extract_parameters(self) -> None:
        self._extract_Vdd_parameters()
        self._extract_PTAT_parameters()
        self._extract_gain_parameters()
        self._extract_px_offset_parameters()
        self._extract_px_alpha_sensitivity()
        self._extract_Kta()
        self._extract_Kv()
        self._extract_gain_parameters()
        self._extract_KsTa()
        self._extract_KsTo()
        self._extract_CT()
        self._extract_alpha_corr_ranges()
        self._extract_Emissivity()
        self._extract_Alpha_CP()
        self._extract_offset_Alpha_CP()
        self._extract_Kv_CP()     
        self._extract_TGC()
        self._extract_resolution()
       
    
    def _extract_Vdd_parameters(self) -> None:
# extract VDD
        self.K_Vdd = (self.ee_data[0x27] & 0x07FF) 
        if self.K_Vdd > 1023:
            self.K_Vdd -= 2048 
        self.K_Vdd *= 32
        self.Vdd_25 = (self.ee_data[0x26] & 0x07FF)
        if self.Vdd_25 >1023:
            self.Vdd_25 -= 2048
        self.Vdd_25 *= 32 
       

    def _extract_PTAT_parameters(self) -> None:
        self.Kv_PTAT = (self.ee_data[0x2B] & 0x07FF)
        if self.Kv_PTAT > 1023:
            self.Kv_PTAT -= 2048
        self.Kv_PTAT /= math.pow(2, 12)

        self.Kt_PTAT = (self.ee_data[0x2A] & 0x07FF)
        if self.Kt_PTAT > 1023:
            self.Kt_PTAT -= 2048
        self.Kt_PTAT /= 8
        self.v_ptat25 = 32*(self.ee_data[0x28] & 0x07FF) + (self.ee_data[0x29]& 0x07FF)
        self.alpha_PTAT = (self.ee_data[0x2c] & 0x07FF) / math.pow(2, 7) 
    
    def _extract_px_offset_parameters(self):
        offset_avg = 32*(self.ee_data[0x11] & 0x07FF) + self.ee_data[0x12] & 0x07FF
        if offset_avg > 32767:
            offset_avg -= 65536
        offset_scale = (self.ee_data[0x10] & 0x07E0)/32
#for each pixel / subpage 0
        for i in range(192):
            px_off = self.ee_data[64+i] & 0x07FF
            if px_off > 1023 :
                px_off-= 2048
            self.px_offset_P0[i] = offset_avg + ((px_off)* math.pow(2, offset_scale))
            if self.px_offset_P0[i] > 1023:
                self.px_offset_P0[i] -= 2048 
#for each pixel / subpage 1    
        for i in range(0, 192,1):
            px_off = self.ee_data[640+i] & 0x07FF
            if px_off > 1023 :
                px_off-= 2048
            self.px_offset_P1[i] = offset_avg + ((px_off)* math.pow(2, offset_scale))
            if self.px_offset_P1[i] > 1023:
                self.px_offset_P1[i] -= 2048           

    def _extract_px_alpha_sensitivity(self):

        max_value_rows =  [0.0]*6
        alpha_scale_row =  [0.0]*6
        alpha_reference_row = [0.0]*6
        alpha_scale_adress = [0x19, 0x1A, 0x1B]



        j=0
        for i in range(28,34,1):
            max_value_rows[j] = (self.ee_data[i] & 0x07FF)
            j +=1
            
        j=0
        for k in alpha_scale_adress:
            alpha_scale_row[j] = ((self.ee_data[k]&0x07E0)/32) + 20
            alpha_scale_row[j+1] = (self.ee_data[k]&0x001F) + 20
            j +=2
        
        for i in range(6):
            alpha_reference_row[i] = max_value_rows[i]/math.pow(2,alpha_scale_row[i])

        for i in range(192):
            self.px_alpha[i]=((self.ee_data[256+i]&0x07FF)*alpha_reference_row[i//32])/(POW2TO11-1)
    def _extract_Kta(self)-> None:
        Kta_scale_1 = (self.ee_data[0x16] & 0x07E0)/32
        Kta_scale_2 = self.ee_data[0x16] & 0x001F
        Kta_avg = self.ee_data[0x15] & 0x07FF
        if Kta_avg > 1023:
            Kta_avg -= 2048

        for i in range(192):
            Kta_ee=(self.ee_data[192+i] & 0x07E0)/32
            if Kta_ee > 31:
                Kta_ee-=64
            self.px_Kta[i]= (Kta_ee * math.pow(2, Kta_scale_2)+ Kta_avg)/math.pow(2, Kta_scale_1)
       
    def _extract_Kv(self)-> None:   
        
        Kv_avg = self.ee_data[0x17] & 0x07FF
        if Kv_avg > 1023:
            Kv_avg -= 2048
        Kv_scale_1 = (self.ee_data[0x18] & 0x07E0)/32
        Kv_scale_2 = self.ee_data[0x18] & 0x001F

        for i in range(192):
            Kv_ee=(self.ee_data[192+i] & 0x0001F)
            if Kv_ee > 15:
                Kv_ee-=32
            self.px_Kv[i]= (Kv_ee * math.pow(2, Kv_scale_2)+ Kv_avg)/math.pow(2, Kv_scale_1)

    def _extract_gain_parameters(self) -> None:
        self.gain_ee = (self.ee_data[0x24]& 0x07FF)*32 + (self.ee_data[0x25] & 0x07FF)

    def _extract_KsTa(self)-> None:
        self.KsTA = self.ee_data[0x22] & 0x07FF
        if self.KsTA > 1023:
            self.KsTA -=2048
         
        self.KsTA /= (2**15)

    def _extract_KsTo(self)-> None:

#EEPROM addresses for KsTo1 to KsTo8
        ksto_addresses = [0x35, 0x36, 0x37, 0x38, 0x39, 0x3B, 0x3D, 0x3F]

        ks_to_scale = self.ee_data[0x34] & 0x07FF

        for i, addr in enumerate(ksto_addresses):
            val = self.ee_data[addr] & 0x07FF 
            if val > 1023:
                val -= 2048 
            
        self.KsTo[i] =  val / math.pow(2,ks_to_scale) 
    
    def _extract_CT(self) -> None:
        self.CT[0] = -40
        self.CT[1] = -20
        self.CT[2] = 0
        self.CT[3] = 80
        self.CT[4] = 120
        self.CT[5]= self.ee_data[0x3A]&0x07FF
        self.CT[6] = self.ee_data[0x3C]&0x07FF 
        self.CT[7] = self.ee_data[0x3E]&0x07FF

    def _extract_alpha_corr_ranges(self) ->None:
        self.Alpha_correction_ranges[0] = 1/(1+self.KsTo[1]*(self.CT[2] - self.CT[1]))
        self.Alpha_correction_ranges[2] = 1
        self.Alpha_correction_ranges[3] = (1+ self.KsTo[2]*(self.CT[3]-self.CT[2]))
        self.Alpha_correction_ranges[1] = 1/(1+self.KsTo[0]*(self.CT[1] - self.CT[0]))*self.Alpha_correction_ranges[1]
        self.Alpha_correction_ranges[4] = (1+ self.KsTo[3]*self.CT[4]- self.CT[3])*self.Alpha_correction_ranges[3]
        self.Alpha_correction_ranges[5] = (1+ self.KsTo[4]*self.CT[5]- self.CT[4])*self.Alpha_correction_ranges[4]
        self.Alpha_correction_ranges[6] = (1+ self.KsTo[5]*self.CT[6]- self.CT[5])*self.Alpha_correction_ranges[5]
        self.Alpha_correction_ranges[7] = (1+ self.KsTo[6]*self.CT[7]- self.CT[6])*self.Alpha_correction_ranges[6]
    def _extract_Emissivity(self)-> None:
        self.Emissivity = self.ee_data[0x23]&0x07FF
        if self.Emissivity > 1023:
            self.Emissivity -=2048
        self.Emissivity /= POW2TO9

    def _extract_Alpha_CP(self)-> None:
        self.Alpha_CP = (self.ee_data[0x2D]& 0x07FF)/ math.pow(2, self.ee_data[0x2E]&0x07FF)

    def _extract_offset_Alpha_CP(self)-> None:
        self.Aplha_CP_offset = 32* (self.ee_data[0x2F]&0x07FF)+ self.ee_data[0x30] & 0x07FF
        if self.Aplha_CP_offset > 32767:
            self.Aplha_CP_offset -= 65536

    def _extract_Kv_CP (self)-> None:
        Kv_CP_ee = self.ee_data[0x32]&0x003F
        if Kv_CP_ee > 32:
            Kv_CP_ee -= 64
        Kv_scale = (self.ee_data[0x32] & 0x07C0) /POW2TO6
        self.Kv_CP = Kv_CP_ee/math.pow(2, Kv_scale)

    def _extract_Kta_CP(self)-> None:
        Kta_CP_ee = self.ee_data[0x31]&0x003F
        if  Kta_CP_ee > 31:
            Kta_CP_ee -=64
        Kta_scale = (self.ee_data[0x31]&0x07C0)/POW2TO6
        self.Kta_CP  =  Kta_CP_ee/math.pow(2, Kta_scale)

    def _extract_TGC(self)-> None:
        TGC_ee = self.ee_data[0x33] & 0x01FF
        if TGC_ee > 255:
            TGC_ee -= 512
        self.TGC = TGC_ee/ (2**6)
    
    def _extract_resolution(self)-> None:
        self.resolution_ee = (self.ee_data[0x33]& 0x0600)/POW2TO9
#other RAM informations 
    def get_read_RAM_others(self)-> None:
       
        self._i2c_read_words(0x0580,self.V_BE_data_0x0580, end=1)
        self._i2c_read_words(0x0588,self.data_0x0588, end=1)
        self._i2c_read_words(0x058A,self.data_0x058A, end=1)
        self._i2c_read_words(0x05A0,self.V_PTAT_data_0x05A0, end=1)
        self._i2c_read_words(0x05A8,self.data_0x05A8, end=1)
        self._i2c_read_words(0x05AA,self.data_0x05AA, end=1)
        tmp_data_Resolution_reg_0x800D=[0]
        self._i2c_read_words(0x800D,tmp_data_Resolution_reg_0x800D, end=1)

        self.data_Resolution_reg_0x800D = (tmp_data_Resolution_reg_0x800D[0]& 0x0C00)/POW2TO10
        if self.data_0x0588[0] > 32767:
            self.data_0x0588[0] -= 65536
        if self.data_0x05A8[0] > 32767:
            self.data_0x05A8[0] -= 65536
        if self.data_0x05AA[0] > 32767:
            self.data_0x05AA[0] -= 65536

    def get_resolution_restore(self)->None:
        self.resolution_corr = math.pow(2, self.resolution_ee)/math.pow(2, self.data_Resolution_reg_0x800D)

    def get_supply_voltage(self):

        self.Vdd = ((1*self.data_0x05AA[0]- self.Vdd_25)/ self.K_Vdd) + VDD_0

    def get_current_Ta(self):

        deltaV = (self.data_0x05AA[0] - self.Vdd_25)/self.K_Vdd
        
#VPTAT
        if self.V_PTAT_data_0x05A0[0]>32737:
            self.V_PTAT_data_0x05A0[0]-=65536
#VBE
        if self.V_BE_data_0x0580[0] > 32767:
            self.V_BE_data_0x0580[0]-=65536
        self.alpha_PTAT = (self.ee_data[0x2C]&0x07FF)/POW2TO7
        
    
        V_PTAT_art = (self.V_PTAT_data_0x05A0[0]/
                      (self.V_PTAT_data_0x05A0[0]*self.alpha_PTAT+self.V_BE_data_0x0580[0]))*POW2TO18
        self.Ta = (((V_PTAT_art/(1+self.Kv_PTAT*deltaV))-self.v_ptat25)/self.Kt_PTAT)+REF_TEMPERATURE 

    def get_K_gain(self):
        self.K_gain = self.gain_ee/self.data_0x058A[0]

    