def catch_fire(sensor_values, limit_value, surroundings_size, alarming_value):
    if len(sensor_values) != 192:
        raise ValueError("Not enough values transferred.")
    values_matrix = [sensor_values[i * 16:(i + 1) * 16] for i in range(12)]
    for i in range(12):
        for j in range(16):
            if values_matrix[i][j] >= limit_value:
                end_i, end_j = i, j
                new_alarming_value = alarming_value
                new_surroundings_size = (surroundings_size, surroundings_size)
                values_over_limit = 0
                if ((i + surroundings_size) > 12):
                    end_i = 12
                    new_surroundings_size = (12 - i, new_surroundings_size[1])
                if (j + surroundings_size > 16):
                    end_j = 16
                    new_surroundings_size = (new_surroundings_size[0], 16 - j)
                if (end_i != i or end_j != j):
                    new_alarming_value = (new_surroundings_size[0] *
                                          new_surroundings_size[1] * (
                        alarming_value / pow(surroundings_size, 2)))
                for di in range(surroundings_size):
                    for dj in range(surroundings_size):
                        ni = i + di
                        nj = j + dj
                        if 0 <= ni < 12 and 0 <= nj < 16:
                            if values_matrix[ni][nj] >= limit_value:
                                values_over_limit += 1
                if (values_over_limit >= new_alarming_value):
                    return 1
    return 0

def print_frame_grid(full_frame):
    print("Raw Pixel Grid (12x16):")
    for row in range(12):
        line = ""
        for col in range(16):
            index = row * 16 + col
            line += f"{full_frame[index]:.0f} "
        print(line)
    print()

def print_thermal_frame(full_frame):
    print("Thermal Pixel Grid (12x16):")
    min_temp = 22.0
    max_temp = 45.0

    # Define a color gradient: dark red → red → orange → yellow → white
    gradient = [
        (64, 0, 0),      # very dark red
        (128, 0, 0),     # red
        (255, 0, 0),     # bright red
        (255, 69, 0),    # orange red
        (255, 140, 0),   # dark orange
        (255, 215, 0),   # gold
        (255, 255, 0),   # yellow
        (255, 255, 128), # light yellow
        (255, 255, 255)  # white
    ]
    grad_steps = len(gradient)

    for row in range(12):
        line = ""
        for col in range(16):
            index = row * 16 + col
            temp = full_frame[index]

            t_norm = (temp - min_temp) / (max_temp - min_temp)
            t_norm = max(0.0, min(1.0, t_norm))

            pos = t_norm * (grad_steps - 1)
            low_idx = int(pos)
            high_idx = min(low_idx + 1, grad_steps - 1)
            frac = pos - low_idx

            r = int((1 - frac) * gradient[low_idx][0] + frac * gradient[high_idx][0])
            g = int((1 - frac) * gradient[low_idx][1] + frac * gradient[high_idx][1])
            b = int((1 - frac) * gradient[low_idx][2] + frac * gradient[high_idx][2])

            line += f"\033[48;2;{r};{g};{b}m  \033[0m"
        print(line)
    print()

def convert_voltage_to_percent(voltage) -> int:
    table= [
        (4.20, 100),
        (4.10, 95),
        (4.00, 90),
        (3.90, 85),
        (3.85, 80),
        (3.80, 75),
        (3.75, 70),
        (3.70, 65),
        (3.65, 55),
        (3.60, 40),
        (3.50, 20),
        (3.40, 10),
        (3.30,  0),
    ]
    for i in range(len(table) - 1):
        v1, c1 = table[i]
        v2, c2 = table[i + 1]
        if v2 <= voltage <= v1:
            return int(c1 + (voltage - v1) * (c2 - c1) / (v2 - v1))
    return 0 if voltage < 3.3 else 100
