class GatheredOverallData:
    def __init__(self):
        self.temperature            = 0.0
        self.bme680_humidity        = 0.0
        self.bme680_temperature     = 0.0
        self.bme680_pressure        = 0.0
        self.bme680_gas_resistance  = 0.0
        self.bme680_gas_calculated  = ""
        self.bme680_status          = 0
        self.camera_data_array      = [0]*192
        self.ina219_current         = 0.0
        self.ina219_voltage         = 0.0
        self.is_charging            = False
        self.sensors_status         = True
        self.battery_percent        = 80

class Settings:
    def __init__(self):
        self.room_volume                   = 0
        self.fire_threshold                = 60
        self.detection_mode                = 2
        self.catch_fire_min_detection_size = 2
        self.catch_fire_alarm_limit        = 2
        self.catch_fire_min_temperature    = 60
        self.gas_threshold = 16000        # NEW
        self.bme_temp_threshold = 50     # NEW

class AlarmHandler:
    def __init__(self):
        self.is_alarm                      = False
        self.is_alarm_to_display           = 0
        self.ir_camera_fire_detected       = 0
        self.bme_fire_detected             = 0
        self.camera_alarm_readings_counter = 0
        self.camera_threshold              = 5
        self.bme_gas_detected              = 0
        self.bme_temp_detected             = 0

    def alarm_callback_off(self):
        self.is_alarm = False
        self.bme_fire_detected = False
        self.bme_gas_detected  = False

    def process_data(self, detection_mode):
        if detection_mode == 1 and self.ir_camera_fire_detected:
            self.is_alarm = True

        elif detection_mode == 2 and self.ir_camera_fire_detected and self.bme_gas_detected:
            self.is_alarm = True

        elif detection_mode == 3 and (self.bme_gas_detected or self.bme_temp_detected):
            self.is_alarm = True
